function [x_last, f_vec, g_vec, f_par, f_orth, angle, lam_vec, x_hist] = DBGD_new(fun_f, grad_f, fun_g, grad_g, param, x0)

disp('DBGD Algorithm starts');
tic;

%% Parameter Initialization
epsilon_f = param.epsilonf;
epsilon_g = param.epsilong;
max_iter = param.max_iter;
stepsize = param.stepsize;
alpha = 1;
beta = param.beta;

x = x0;
f_vec = [];  % Store ||∇d_k||^2 values
f_orth = [];
f_par = [];
angle = [];
g_vec = [];  % Store ||∇g||^2 values
lam_vec = [];
x_hist = x0'; % Track x history

%% Main Optimization Loop
for iter = 1:max_iter
    % Compute Gradients
    grad_f_x = grad_f(x);
    grad_g_x = grad_g(x);

    % Compute φ(x)
    phi = beta * (grad_g_x' * grad_g_x);

    % Compute λ_k (Weight)
    weight = max((phi - grad_f_x' * grad_g_x) / (grad_g_x' * grad_g_x), 0);
%     weight = (phi - grad_f_x' * grad_g_x) / (grad_g_x' * grad_g_x);

    % Update x
    x = x - stepsize * (grad_f_x + weight * grad_g_x);

    % Store Metrics
    f_vec = [f_vec; norm(grad_f_x + weight * grad_g_x)^2];
    f_par = [f_par;norm((grad_f_x'*grad_g_x)/(grad_g_x'*grad_g_x)*grad_g_x)^2];
    f_orth = [f_orth;norm(grad_f_x - (grad_f_x'*grad_g_x)/(grad_g_x'*grad_g_x)*grad_g_x)^2];
    angle = [angle;(grad_f_x'*grad_g_x)/norm(grad_f_x)/norm(grad_g_x)];
%     angle = [angle;(grad_f_x'*grad_g_x)];
    g_vec = [g_vec; norm(grad_g_x)^2];
    lam_vec = [lam_vec; weight];
    x_hist = [x_hist; x'];

    % Break Condition (Optional: Can add stopping criteria based on ε)
end

x_last = x; % Final solution
disp('DBGD Algorithm ends');

end
